import { Ticket, Calendar, QrCode } from 'lucide-react';

export default function MyTickets() {
    return (
        <div className="page">
            <div className="page-header">
                <h1 className="page-title">Mis Entradas</h1>
                <p className="page-subtitle">Presenta el QR en la entrada del evento</p>
            </div>

            {mockTickets.length === 0 ? (
                <div style={{ textAlign: 'center', padding: '3rem 1rem', color: '#6b7280' }}>
                    <Ticket size={64} style={{ opacity: 0.3, marginBottom: '1rem' }} />
                    <h3 style={{ marginBottom: '0.5rem' }}>No tienes entradas</h3>
                    <p>Explora nuestros eventos y compra tu primera entrada</p>
                </div>
            ) : (
                mockTickets.map(ticket => (
                    <div key={ticket.id} className="ticket">
                        <div className="ticket-header">
                            <h3 style={{ fontWeight: 600, marginBottom: '0.25rem' }}>{ticket.event}</h3>
                            <div style={{ display: 'flex', gap: '1rem', fontSize: '0.875rem', opacity: 0.9 }}>
                                <span><Calendar size={14} style={{ marginRight: 4 }} />{ticket.date}</span>
                            </div>
                        </div>
                        <div className="ticket-qr">
                            <div style={{ width: 180, height: 180, margin: '0 auto', background: '#f3f4f6', borderRadius: 12, display: 'flex', alignItems: 'center', justifyContent: 'center' }}>
                                <QrCode size={120} color="#374151" />
                            </div>
                            <p style={{ marginTop: '1rem', fontFamily: 'monospace', fontSize: '1.125rem', fontWeight: 600 }}>{ticket.code}</p>
                        </div>
                        <div className="ticket-info">
                            <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                <span style={{ color: '#6b7280' }}>Estado</span>
                                <span className={`badge badge-${ticket.status === 'valid' ? 'success' : 'gray'}`}>
                                    {ticket.status === 'valid' ? 'Válida' : 'Usada'}
                                </span>
                            </div>
                        </div>
                    </div>
                ))
            )}
        </div>
    );
}

const mockTickets = [
    { id: 1, event: 'Noche de Inauguración', date: '15 Ene 2024, 21:00', code: 'TKT-A8B2C9D1E4F5', status: 'valid' },
    { id: 2, event: 'After Office Viernes', date: '12 Ene 2024, 18:00', code: 'TKT-X7Y3Z2W1Q5R8', status: 'used' },
];
