import { Calendar, MapPin, Ticket } from 'lucide-react';
import { Link } from 'react-router-dom';

export default function HomePage() {
    return (
        <div className="page">
            <div className="hero">
                <h1 className="hero-title">¡Bienvenido!</h1>
                <p className="hero-text">Descubre los mejores eventos y reserva tu entrada</p>
            </div>

            <h2 style={{ fontSize: '1.25rem', fontWeight: 600, marginBottom: '1rem' }}>Próximos Eventos</h2>

            {mockEvents.map(event => (
                <Link to={`/events/${event.id}`} key={event.id} style={{ textDecoration: 'none', color: 'inherit' }}>
                    <div className="card event-card">
                        <div className="card-img" style={{ background: `linear-gradient(135deg, ${event.color1}, ${event.color2})`, display: 'flex', alignItems: 'center', justifyContent: 'center' }}>
                            <Ticket size={48} color="white" style={{ opacity: 0.5 }} />
                        </div>
                        <div className="event-content">
                            <h3 className="event-title">{event.name}</h3>
                            <div className="event-meta">
                                <span className="event-meta-item"><Calendar size={14} />{event.date}</span>
                                <span className="event-meta-item"><MapPin size={14} />{event.location}</span>
                            </div>
                            <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
                                {event.price === 0 ? (
                                    <span className="event-price event-price-free">Gratis</span>
                                ) : (
                                    <span className="event-price">${event.price.toLocaleString()}</span>
                                )}
                                <span className="badge badge-primary">{event.available} disponibles</span>
                            </div>
                        </div>
                    </div>
                </Link>
            ))}
        </div>
    );
}

const mockEvents = [
    { id: 1, name: 'Noche de Inauguración', date: '15 Ene, 21:00', location: 'Salón Principal', price: 15000, available: 55, color1: '#6366f1', color2: '#ec4899' },
    { id: 2, name: 'After Office Viernes', date: '12 Ene, 18:00', location: 'Terraza', price: 0, available: 61, color1: '#10b981', color2: '#3b82f6' },
    { id: 3, name: 'Fiesta Retro 80s', date: '20 Ene, 22:00', location: 'Salón Principal', price: 12000, available: 180, color1: '#f59e0b', color2: '#ef4444' },
];
