import { Calendar, MapPin, Ticket, Search } from 'lucide-react';
import { useState } from 'react';
import { Link } from 'react-router-dom';

export default function EventsPage() {
    const [search, setSearch] = useState('');
    const [filter, setFilter] = useState('all');

    const filtered = mockEvents.filter(e => {
        if (filter === 'free' && e.price > 0) return false;
        if (filter === 'paid' && e.price === 0) return false;
        if (search && !e.name.toLowerCase().includes(search.toLowerCase())) return false;
        return true;
    });

    return (
        <div className="page">
            <div className="page-header">
                <h1 className="page-title">Eventos</h1>
                <p className="page-subtitle">Descubre y reserva tu próximo evento</p>
            </div>

            <div style={{ position: 'relative', marginBottom: '1rem' }}>
                <Search size={18} style={{ position: 'absolute', left: '1rem', top: '50%', transform: 'translateY(-50%)', color: '#9ca3af' }} />
                <input className="form-input" placeholder="Buscar evento..." value={search} onChange={e => setSearch(e.target.value)}
                    style={{ paddingLeft: '2.75rem' }} />
            </div>

            <div style={{ display: 'flex', gap: '0.5rem', marginBottom: '1rem', overflowX: 'auto' }}>
                {[['all', 'Todos'], ['free', 'Gratis'], ['paid', 'De pago']].map(([val, label]) => (
                    <button key={val} onClick={() => setFilter(val)}
                        style={{
                            padding: '0.5rem 1rem', borderRadius: '9999px', border: 'none', fontSize: '0.875rem', fontWeight: 500,
                            background: filter === val ? '#6366f1' : '#f3f4f6', color: filter === val ? 'white' : '#374151', cursor: 'pointer', whiteSpace: 'nowrap'
                        }}>
                        {label}
                    </button>
                ))}
            </div>

            {filtered.map(event => (
                <Link to={`/events/${event.id}`} key={event.id} style={{ textDecoration: 'none', color: 'inherit' }}>
                    <div className="card event-card">
                        <div className="card-img" style={{ background: `linear-gradient(135deg, ${event.color1}, ${event.color2})`, display: 'flex', alignItems: 'center', justifyContent: 'center' }}>
                            <Ticket size={48} color="white" style={{ opacity: 0.5 }} />
                        </div>
                        <div className="event-content">
                            <h3 className="event-title">{event.name}</h3>
                            <div className="event-meta">
                                <span className="event-meta-item"><Calendar size={14} />{event.date}</span>
                                <span className="event-meta-item"><MapPin size={14} />{event.location}</span>
                            </div>
                            <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
                                {event.price === 0 ? <span className="event-price event-price-free">Gratis</span> : <span className="event-price">${event.price.toLocaleString()}</span>}
                                <span className="badge badge-primary">{event.available} disponibles</span>
                            </div>
                        </div>
                    </div>
                </Link>
            ))}
        </div>
    );
}

const mockEvents = [
    { id: 1, name: 'Noche de Inauguración', date: '15 Ene, 21:00', location: 'Salón Principal', price: 15000, available: 55, color1: '#6366f1', color2: '#ec4899' },
    { id: 2, name: 'After Office Viernes', date: '12 Ene, 18:00', location: 'Terraza', price: 0, available: 61, color1: '#10b981', color2: '#3b82f6' },
    { id: 3, name: 'Fiesta Retro 80s', date: '20 Ene, 22:00', location: 'Salón Principal', price: 12000, available: 180, color1: '#f59e0b', color2: '#ef4444' },
];
