import { useState } from 'react';
import { useParams, useNavigate } from 'react-router-dom';
import { Calendar, Clock, MapPin, Users, Minus, Plus, ChevronLeft } from 'lucide-react';

export default function EventDetail() {
    const { id } = useParams();
    const navigate = useNavigate();
    const [quantity, setQuantity] = useState(1);
    const [selectedTable, setSelectedTable] = useState(null);
    const [step, setStep] = useState(1);

    const event = mockEvents.find(e => e.id === parseInt(id)) || mockEvents[0];
    const total = event.price * quantity;

    const handlePurchase = () => {
        if (step === 1) { setStep(2); return; }
        alert(`Redirigiendo al pago...\nTotal: $${total.toLocaleString()}\n${selectedTable ? `Mesa: ${selectedTable}` : ''}`);
    };

    return (
        <div className="page" style={{ padding: 0 }}>
            <div style={{ position: 'relative' }}>
                <div style={{ height: 200, background: `linear-gradient(135deg, ${event.color1}, ${event.color2})` }}></div>
                <button onClick={() => navigate(-1)} style={{ position: 'absolute', top: '1rem', left: '1rem', width: 40, height: 40, borderRadius: '50%', background: 'rgba(0,0,0,0.3)', border: 'none', color: 'white', cursor: 'pointer', display: 'flex', alignItems: 'center', justifyContent: 'center' }}>
                    <ChevronLeft size={24} />
                </button>
            </div>

            <div style={{ padding: '1.5rem', marginTop: -30, background: 'white', borderRadius: '1.5rem 1.5rem 0 0', minHeight: 'calc(100vh - 170px)' }}>
                <h1 style={{ fontSize: '1.5rem', fontWeight: 700, marginBottom: '1rem' }}>{event.name}</h1>

                <div style={{ display: 'flex', flexWrap: 'wrap', gap: '1rem', marginBottom: '1.5rem' }}>
                    {[[Calendar, event.date], [Clock, event.time], [MapPin, event.location], [Users, `${event.available} disponibles`]].map(([Icon, text], i) => (
                        <div key={i} style={{ display: 'flex', alignItems: 'center', gap: '0.5rem', color: '#6b7280', fontSize: '0.9375rem' }}>
                            <Icon size={18} /><span>{text}</span>
                        </div>
                    ))}
                </div>

                <p style={{ color: '#4b5563', marginBottom: '1.5rem', lineHeight: 1.6 }}>{event.description}</p>

                {step === 1 ? (
                    <>
                        <div style={{ background: '#f9fafb', borderRadius: '1rem', padding: '1.25rem', marginBottom: '1.5rem' }}>
                            <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', marginBottom: '1rem' }}>
                                <span style={{ fontWeight: 500 }}>Cantidad de entradas</span>
                                <div className="qty-selector">
                                    <button className="qty-btn" onClick={() => setQuantity(Math.max(1, quantity - 1))}>−</button>
                                    <span className="qty-value">{quantity}</span>
                                    <button className="qty-btn" onClick={() => setQuantity(Math.min(10, quantity + 1))}>+</button>
                                </div>
                            </div>
                            <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
                                <span style={{ fontWeight: 500 }}>Total</span>
                                <span style={{ fontSize: '1.5rem', fontWeight: 700, color: '#6366f1' }}>
                                    {total === 0 ? 'Gratis' : `$${total.toLocaleString()}`}
                                </span>
                            </div>
                        </div>
                    </>
                ) : (
                    <>
                        <h3 style={{ fontWeight: 600, marginBottom: '1rem' }}>Selecciona tu mesa (opcional)</h3>
                        <div className="table-grid">
                            {mockTables.map(table => (
                                <div key={table.id} onClick={() => table.available && setSelectedTable(table.name)}
                                    className={`table-item ${table.available ? 'available' : 'reserved'} ${selectedTable === table.name ? 'selected' : ''}`}>
                                    <span style={{ fontWeight: 600 }}>{table.name}</span>
                                    <span style={{ fontSize: '0.625rem' }}>{table.capacity} pers.</span>
                                </div>
                            ))}
                        </div>
                        {selectedTable && <p style={{ color: '#10b981', marginTop: '0.5rem' }}>Mesa seleccionada: {selectedTable}</p>}
                    </>
                )}

                <button className="btn btn-primary btn-lg" onClick={handlePurchase} style={{ marginTop: '1rem' }}>
                    {step === 1 ? 'Continuar' : total === 0 ? 'Confirmar Reserva' : `Pagar $${total.toLocaleString()}`}
                </button>
            </div>
        </div>
    );
}

const mockEvents = [
    { id: 1, name: 'Noche de Inauguración', date: '15 Enero 2024', time: '21:00 - 04:00', location: 'Salón Principal', price: 15000, available: 55, color1: '#6366f1', color2: '#ec4899', description: 'Gran evento de inauguración con música en vivo y DJ internacional. No te pierdas esta noche única.' },
    { id: 2, name: 'After Office Viernes', date: '12 Enero 2024', time: '18:00 - 23:00', location: 'Terraza', price: 0, available: 61, color1: '#10b981', color2: '#3b82f6', description: 'El mejor after office de la ciudad. Happy hour hasta las 21hrs con tragos 2x1.' },
    { id: 3, name: 'Fiesta Retro 80s', date: '20 Enero 2024', time: '22:00 - 05:00', location: 'Salón Principal', price: 12000, available: 180, color1: '#f59e0b', color2: '#ef4444', description: 'Viaja al pasado con los mejores hits de los 80s. Dress code: retro vibes.' },
];

const mockTables = [
    { id: 1, name: 'Mesa 1', capacity: 4, available: true },
    { id: 2, name: 'Mesa 2', capacity: 4, available: false },
    { id: 3, name: 'Mesa 3', capacity: 6, available: true },
    { id: 4, name: 'Mesa 4', capacity: 4, available: true },
    { id: 5, name: 'Mesa 5', capacity: 8, available: true },
    { id: 6, name: 'VIP 1', capacity: 6, available: false },
];
