import { User, Gift, History, Settings, LogOut, ChevronRight } from 'lucide-react';

export default function Account() {
    const user = { name: 'Usuario Demo', email: 'demo@email.com', points: 1250 };

    return (
        <div className="page">
            <div className="page-header">
                <h1 className="page-title">Mi Cuenta</h1>
            </div>

            <div className="card" style={{ marginBottom: '1.5rem' }}>
                <div style={{ padding: '1.5rem', display: 'flex', alignItems: 'center', gap: '1rem' }}>
                    <div style={{ width: 60, height: 60, borderRadius: '50%', background: 'linear-gradient(135deg, #6366f1, #ec4899)', display: 'flex', alignItems: 'center', justifyContent: 'center', color: 'white', fontSize: '1.5rem', fontWeight: 700 }}>
                        {user.name.charAt(0)}
                    </div>
                    <div>
                        <h2 style={{ fontWeight: 600, marginBottom: '0.25rem' }}>{user.name}</h2>
                        <p style={{ color: '#6b7280', fontSize: '0.875rem' }}>{user.email}</p>
                    </div>
                </div>
            </div>

            <div className="card" style={{ marginBottom: '1.5rem' }}>
                <div style={{ padding: '1.5rem', display: 'flex', alignItems: 'center', justifyContent: 'space-between' }}>
                    <div style={{ display: 'flex', alignItems: 'center', gap: '1rem' }}>
                        <div style={{ width: 48, height: 48, borderRadius: 12, background: 'linear-gradient(135deg, #fef3c7, #fde68a)', display: 'flex', alignItems: 'center', justifyContent: 'center' }}>
                            <Gift size={24} color="#d97706" />
                        </div>
                        <div>
                            <p style={{ color: '#6b7280', fontSize: '0.875rem' }}>Puntos acumulados</p>
                            <p style={{ fontSize: '1.5rem', fontWeight: 700, color: '#d97706' }}>{user.points.toLocaleString()}</p>
                        </div>
                    </div>
                    <ChevronRight size={20} color="#9ca3af" />
                </div>
            </div>

            <div className="card">
                {[
                    { icon: History, label: 'Historial de compras', action: () => { } },
                    { icon: Settings, label: 'Configuración', action: () => { } },
                    { icon: LogOut, label: 'Cerrar sesión', action: () => { }, danger: true },
                ].map((item, i) => (
                    <div key={i} onClick={item.action}
                        style={{ padding: '1rem 1.5rem', display: 'flex', alignItems: 'center', justifyContent: 'space-between', cursor: 'pointer', borderBottom: i < 2 ? '1px solid #f3f4f6' : 'none' }}>
                        <div style={{ display: 'flex', alignItems: 'center', gap: '0.75rem', color: item.danger ? '#ef4444' : '#374151' }}>
                            <item.icon size={20} />
                            <span style={{ fontWeight: 500 }}>{item.label}</span>
                        </div>
                        <ChevronRight size={18} color="#9ca3af" />
                    </div>
                ))}
            </div>
        </div>
    );
}
