import { BrowserRouter, Routes, Route, NavLink } from 'react-router-dom';
import { Home, Calendar, Ticket, User } from 'lucide-react';
import HomePage from './pages/Home';
import EventsPage from './pages/Events';
import EventDetail from './pages/EventDetail';
import MyTickets from './pages/MyTickets';
import Account from './pages/Account';

export default function App() {
    return (
        <BrowserRouter>
            <div className="app">
                <Routes>
                    <Route path="/" element={<HomePage />} />
                    <Route path="/events" element={<EventsPage />} />
                    <Route path="/events/:id" element={<EventDetail />} />
                    <Route path="/tickets" element={<MyTickets />} />
                    <Route path="/account" element={<Account />} />
                </Routes>

                <nav className="bottom-nav">
                    <NavLink to="/" className={({ isActive }) => `nav-item ${isActive ? 'active' : ''}`} end>
                        <Home /><span>Inicio</span>
                    </NavLink>
                    <NavLink to="/events" className={({ isActive }) => `nav-item ${isActive ? 'active' : ''}`}>
                        <Calendar /><span>Eventos</span>
                    </NavLink>
                    <NavLink to="/tickets" className={({ isActive }) => `nav-item ${isActive ? 'active' : ''}`}>
                        <Ticket /><span>Entradas</span>
                    </NavLink>
                    <NavLink to="/account" className={({ isActive }) => `nav-item ${isActive ? 'active' : ''}`}>
                        <User /><span>Cuenta</span>
                    </NavLink>
                </nav>
            </div>
        </BrowserRouter>
    );
}
