<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Room;
use App\Models\Table;
use App\Models\Event;
use App\Models\Setting;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create admin user
        User::create([
            'name' => 'Administrador',
            'email' => 'admin@sistema.local',
            'password' => Hash::make('admin123'),
            'role' => 'admin',
            'status' => 'active',
        ]);

        // Create cashier user
        User::create([
            'name' => 'Cajero',
            'email' => 'cajero@sistema.local',
            'password' => Hash::make('cajero123'),
            'role' => 'cashier',
            'status' => 'active',
        ]);

        // Create demo rooms
        $salonPrincipal = Room::create([
            'name' => 'Salón Principal',
            'description' => 'Salón principal con capacidad para 100 personas',
            'capacity' => 100,
            'is_active' => true,
        ]);

        $terraza = Room::create([
            'name' => 'Terraza VIP',
            'description' => 'Terraza exclusiva con vista panorámica',
            'capacity' => 40,
            'is_active' => true,
        ]);

        // Create tables for Salón Principal
        $tablePositions = [
            ['name' => 'Mesa 1', 'x' => 50, 'y' => 50, 'capacity' => 4],
            ['name' => 'Mesa 2', 'x' => 150, 'y' => 50, 'capacity' => 4],
            ['name' => 'Mesa 3', 'x' => 250, 'y' => 50, 'capacity' => 6],
            ['name' => 'Mesa 4', 'x' => 50, 'y' => 150, 'capacity' => 4],
            ['name' => 'Mesa 5', 'x' => 150, 'y' => 150, 'capacity' => 8],
            ['name' => 'Mesa 6', 'x' => 250, 'y' => 150, 'capacity' => 4],
        ];

        foreach ($tablePositions as $pos) {
            $salonPrincipal->tables()->create([
                'name' => $pos['name'],
                'capacity' => $pos['capacity'],
                'position_x' => $pos['x'],
                'position_y' => $pos['y'],
                'shape' => $pos['capacity'] > 6 ? 'rectangle' : 'circle',
                'status' => 'available',
            ]);
        }

        // Create tables for Terraza
        for ($i = 1; $i <= 4; $i++) {
            $terraza->tables()->create([
                'name' => "Mesa VIP $i",
                'capacity' => 6,
                'position_x' => 50 + (($i - 1) % 2) * 150,
                'position_y' => 50 + floor(($i - 1) / 2) * 100,
                'shape' => 'square',
                'status' => 'available',
            ]);
        }

        // Create demo events
        Event::create([
            'name' => 'Noche de Inauguración',
            'description' => 'Gran evento de inauguración con música en vivo y DJ internacional.',
            'start_date' => now()->addDays(7),
            'start_time' => '21:00',
            'end_time' => '04:00',
            'type' => 'paid',
            'ticket_price' => 15000,
            'total_capacity' => 200,
            'status' => 'active',
        ]);

        Event::create([
            'name' => 'After Office Viernes',
            'description' => 'El mejor after office de la ciudad. Happy hour hasta las 21hrs.',
            'start_date' => now()->addDays(3),
            'start_time' => '18:00',
            'end_time' => '23:00',
            'type' => 'free',
            'ticket_price' => 0,
            'total_capacity' => 150,
            'status' => 'active',
        ]);

        // Default settings
        foreach (Setting::defaults() as $key => $data) {
            Setting::set($key, $data['value'], $data['group'], $data['type']);
        }

        $this->command->info('✅ Base de datos inicializada correctamente');
        $this->command->info('   Admin: admin@sistema.local / admin123');
        $this->command->info('   Cajero: cajero@sistema.local / cajero123');
    }
}
