<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rooms', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->integer('capacity')->default(0);
            $table->string('floor_plan')->nullable(); // SVG or image path
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        Schema::create('event_rooms', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->constrained()->onDelete('cascade');
            $table->foreignId('room_id')->constrained()->onDelete('cascade');
            $table->integer('capacity_override')->nullable();
            $table->timestamps();

            $table->unique(['event_id', 'room_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('event_rooms');
        Schema::dropIfExists('rooms');
    }
};
