<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('image')->nullable();
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->time('start_time');
            $table->time('end_time')->nullable();
            $table->enum('type', ['paid', 'free'])->default('paid');
            $table->decimal('ticket_price', 10, 2)->default(0);
            $table->integer('total_capacity')->default(0);
            $table->enum('status', ['draft', 'active', 'hidden', 'finished'])->default('draft');
            $table->timestamps();

            $table->index('status');
            $table->index('start_date');
            $table->index(['status', 'start_date']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('events');
    }
};
