<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Flow Gateway Configuration
    |--------------------------------------------------------------------------
    */
    'flow' => [
        'api_key' => env('FLOW_API_KEY'),
        'secret_key' => env('FLOW_SECRET_KEY'),
        'api_url' => env('FLOW_API_URL', 'https://sandbox.flow.cl/api'),
        'return_url' => env('FLOW_RETURN_URL'),
        'webhook_url' => env('FLOW_WEBHOOK_URL'),
    ],

    /*
    |--------------------------------------------------------------------------
    | 360Messenger WhatsApp Configuration
    |--------------------------------------------------------------------------
    */
    'whatsapp' => [
        'api_url' => env('WHATSAPP_API_URL'),
        'api_key' => env('WHATSAPP_API_KEY'),
        'phone' => env('WHATSAPP_PHONE'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Google Maps Configuration
    |--------------------------------------------------------------------------
    */
    'google_maps' => [
        'api_key' => env('GOOGLE_MAPS_API_KEY'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Points System Configuration
    |--------------------------------------------------------------------------
    */
    'points' => [
        'enabled' => true,
        'points_per_currency' => 1, // 1 point per $1000 CLP
        'currency_divisor' => 1000,
    ],

    /*
    |--------------------------------------------------------------------------
    | QR Code Configuration
    |--------------------------------------------------------------------------
    */
    'qr' => [
        'size' => 300,
        'margin' => 1,
        'format' => 'png',
    ],
];
