<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'capacity',
        'floor_plan',
        'is_active',
    ];

    protected $casts = [
        'capacity' => 'integer',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function tables()
    {
        return $this->hasMany(Table::class);
    }

    public function events()
    {
        return $this->belongsToMany(Event::class, 'event_rooms')
            ->withPivot('capacity_override')
            ->withTimestamps();
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Helpers
    public function getAvailableTables()
    {
        return $this->tables()->where('status', 'available')->get();
    }

    public function getTotalTableCapacity(): int
    {
        return $this->tables()->sum('capacity');
    }
}
