<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_id',
        'flow_token',
        'method',
        'amount',
        'status',
        'flow_response',
        'paid_at',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'flow_response' => 'array',
        'paid_at' => 'datetime',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    // Scopes
    public function scopeCompleted($query)
    {
        return $query->where('status', 'completed');
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    // Helpers
    public function isPending(): bool
    {
        return $this->status === 'pending';
    }

    public function isCompleted(): bool
    {
        return $this->status === 'completed';
    }

    public function isFailed(): bool
    {
        return $this->status === 'failed';
    }

    public function markAsCompleted(array $flowResponse = []): void
    {
        $this->update([
            'status' => 'completed',
            'flow_response' => $flowResponse,
            'paid_at' => now(),
        ]);
    }

    public function markAsFailed(array $flowResponse = []): void
    {
        $this->update([
            'status' => 'failed',
            'flow_response' => $flowResponse,
        ]);
    }
}
