# 🚀 Guía de Despliegue en cPanel (SIN npm requerido)

> Tu hosting no tiene npm. Esta guía usa versiones HTML puras que no necesitan compilación.

---

## Paso 1: Crear Base de Datos en cPanel

1. Ingresa a **cPanel** → **Bases de datos MySQL**
2. Crear base de datos y usuario
3. Asignar privilegios

**Tus datos:**
```
Base de datos: miho_reservas
Usuario: miho_reservas
Contraseña: [tu contraseña]
```

---

## Paso 2: Subir los Archivos

### Estructura final en tu hosting:
```
/home/miho/public_html/reservas.mihosting.cc/
├── api/           ← Backend Laravel
├── admin/         ← Panel Admin (1 archivo HTML)
├── app/           ← Cliente Web (1 archivo HTML)
└── .htaccess      ← Rutas
```

### Instrucciones:
1. En tu Mac, abre **Finder**
2. Ve a: `/Users/sistem/Documents/Proyectos/Reservas Restaurante`
3. Verás las carpetas: `api`, `admin`, `app`
4. **Comprime cada carpeta por separado** (clic derecho → Comprimir)
5. Sube cada .zip a cPanel → Administrador de archivos
6. Extrae cada uno en `/home/miho/public_html/reservas.mihosting.cc/`

---

## Paso 3: Configurar Laravel

En la **Terminal de cPanel**, ejecuta:

```bash
cd /home/miho/public_html/reservas.mihosting.cc/api

# Editar configuración
nano .env
```

Cambia estos valores:
```env
APP_ENV=production
APP_DEBUG=false
APP_URL=https://reservas.mihosting.cc
DB_HOST=localhost
DB_DATABASE=miho_reservas
DB_USERNAME=miho_reservas
DB_PASSWORD=[tu contraseña]
```

Guarda: `Ctrl+O`, `Enter`, `Ctrl+X`

Luego ejecuta:
```bash
# Instalar Laravel
composer install --no-dev --optimize-autoloader

# Generar claves
php artisan key:generate
php artisan jwt:secret --force

# Crear tablas
php artisan migrate --seed

# Permisos
chmod -R 755 storage bootstrap/cache
```

---

## Paso 4: Crear .htaccess

En **Administrador de archivos**, navega a:
`/home/miho/public_html/reservas.mihosting.cc/`

Crea archivo `.htaccess` con este contenido:

```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    
    # API Laravel
    RewriteCond %{REQUEST_URI} ^/api
    RewriteRule ^api/(.*)$ api/public/$1 [L]
</IfModule>
```

---

## Paso 5: Probar

| URL | Qué verás |
|-----|-----------|
| https://reservas.mihosting.cc/api/health | `{"status":"ok"}` |
| https://reservas.mihosting.cc/admin/ | Panel de administración |
| https://reservas.mihosting.cc/app/ | Cliente web móvil |

**Login admin:** `admin@sistema.local` / `admin123`

---

## ❌ Si tienes errores

### "Could not open input file: artisan"
El archivo artisan faltaba. Ya lo agregué. Vuelve a subir la carpeta `api`.

### Error 500
```bash
cat /home/miho/public_html/reservas.mihosting.cc/api/storage/logs/laravel.log | tail -30
```

### "Class not found"
```bash
cd /home/miho/public_html/reservas.mihosting.cc/api
composer dump-autoload
```
